import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { V4PagePaginationArray, type V4PagePaginationArrayParams } from "../../../pagination.js";
export declare class ImpersonationRegistry extends APIResource {
    /**
     * Create an entry in impersonation registry
     */
    create(params: ImpersonationRegistryCreateParams, options?: Core.RequestOptions): Core.APIPromise<ImpersonationRegistryCreateResponse>;
    /**
     * Lists, searches, and sorts entries in the impersonation registry.
     */
    list(params: ImpersonationRegistryListParams, options?: Core.RequestOptions): Core.PagePromise<ImpersonationRegistryListResponsesV4PagePaginationArray, ImpersonationRegistryListResponse>;
    /**
     * Delete an entry from impersonation registry
     */
    delete(displayNameId: number, params: ImpersonationRegistryDeleteParams, options?: Core.RequestOptions): Core.APIPromise<ImpersonationRegistryDeleteResponse>;
    /**
     * Update an entry in impersonation registry
     */
    edit(displayNameId: number, params: ImpersonationRegistryEditParams, options?: Core.RequestOptions): Core.APIPromise<ImpersonationRegistryEditResponse>;
    /**
     * Get an entry in impersonation registry
     */
    get(displayNameId: number, params: ImpersonationRegistryGetParams, options?: Core.RequestOptions): Core.APIPromise<ImpersonationRegistryGetResponse>;
}
export declare class ImpersonationRegistryListResponsesV4PagePaginationArray extends V4PagePaginationArray<ImpersonationRegistryListResponse> {
}
export interface ImpersonationRegistryCreateResponse {
    id: number;
    created_at: string;
    email: string;
    is_email_regex: boolean;
    last_modified: string;
    name: string;
    comments?: string | null;
    directory_id?: number | null;
    directory_node_id?: number | null;
    /**
     * @deprecated
     */
    external_directory_node_id?: string | null;
    provenance?: string | null;
}
export interface ImpersonationRegistryListResponse {
    id: number;
    created_at: string;
    email: string;
    is_email_regex: boolean;
    last_modified: string;
    name: string;
    comments?: string | null;
    directory_id?: number | null;
    directory_node_id?: number | null;
    /**
     * @deprecated
     */
    external_directory_node_id?: string | null;
    provenance?: string | null;
}
export interface ImpersonationRegistryDeleteResponse {
    id: number;
}
export interface ImpersonationRegistryEditResponse {
    id: number;
    created_at: string;
    email: string;
    is_email_regex: boolean;
    last_modified: string;
    name: string;
    comments?: string | null;
    directory_id?: number | null;
    directory_node_id?: number | null;
    /**
     * @deprecated
     */
    external_directory_node_id?: string | null;
    provenance?: string | null;
}
export interface ImpersonationRegistryGetResponse {
    id: number;
    created_at: string;
    email: string;
    is_email_regex: boolean;
    last_modified: string;
    name: string;
    comments?: string | null;
    directory_id?: number | null;
    directory_node_id?: number | null;
    /**
     * @deprecated
     */
    external_directory_node_id?: string | null;
    provenance?: string | null;
}
export interface ImpersonationRegistryCreateParams {
    /**
     * Path param: Account Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    email: string;
    /**
     * Body param:
     */
    is_email_regex: boolean;
    /**
     * Body param:
     */
    name: string;
}
export interface ImpersonationRegistryListParams extends V4PagePaginationArrayParams {
    /**
     * Path param: Account Identifier
     */
    account_id: string;
    /**
     * Query param: The sorting direction.
     */
    direction?: 'asc' | 'desc';
    /**
     * Query param: The field to sort by.
     */
    order?: 'name' | 'email' | 'created_at';
    /**
     * Query param:
     */
    provenance?: 'A1S_INTERNAL' | 'SNOOPY-CASB_OFFICE_365' | 'SNOOPY-OFFICE_365' | 'SNOOPY-GOOGLE_DIRECTORY';
    /**
     * Query param: Allows searching in multiple properties of a record simultaneously.
     * This parameter is intended for human users, not automation. Its exact behavior
     * is intentionally left unspecified and is subject to change in the future.
     */
    search?: string;
}
export interface ImpersonationRegistryDeleteParams {
    /**
     * Account Identifier
     */
    account_id: string;
}
export interface ImpersonationRegistryEditParams {
    /**
     * Path param: Account Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    email?: string | null;
    /**
     * Body param:
     */
    is_email_regex?: boolean | null;
    /**
     * Body param:
     */
    name?: string | null;
}
export interface ImpersonationRegistryGetParams {
    /**
     * Account Identifier
     */
    account_id: string;
}
export declare namespace ImpersonationRegistry {
    export { type ImpersonationRegistryCreateResponse as ImpersonationRegistryCreateResponse, type ImpersonationRegistryListResponse as ImpersonationRegistryListResponse, type ImpersonationRegistryDeleteResponse as ImpersonationRegistryDeleteResponse, type ImpersonationRegistryEditResponse as ImpersonationRegistryEditResponse, type ImpersonationRegistryGetResponse as ImpersonationRegistryGetResponse, ImpersonationRegistryListResponsesV4PagePaginationArray as ImpersonationRegistryListResponsesV4PagePaginationArray, type ImpersonationRegistryCreateParams as ImpersonationRegistryCreateParams, type ImpersonationRegistryListParams as ImpersonationRegistryListParams, type ImpersonationRegistryDeleteParams as ImpersonationRegistryDeleteParams, type ImpersonationRegistryEditParams as ImpersonationRegistryEditParams, type ImpersonationRegistryGetParams as ImpersonationRegistryGetParams, };
}
//# sourceMappingURL=impersonation-registry.d.ts.map