"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImpersonationRegistryListResponsesV4PagePaginationArray = exports.ImpersonationRegistry = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class ImpersonationRegistry extends resource_1.APIResource {
    /**
     * Create an entry in impersonation registry
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email-security/settings/impersonation_registry`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists, searches, and sorts entries in the impersonation registry.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/impersonation_registry`, ImpersonationRegistryListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete an entry from impersonation registry
     */
    delete(displayNameId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email-security/settings/impersonation_registry/${displayNameId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an entry in impersonation registry
     */
    edit(displayNameId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/email-security/settings/impersonation_registry/${displayNameId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get an entry in impersonation registry
     */
    get(displayNameId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/settings/impersonation_registry/${displayNameId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.ImpersonationRegistry = ImpersonationRegistry;
class ImpersonationRegistryListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.ImpersonationRegistryListResponsesV4PagePaginationArray = ImpersonationRegistryListResponsesV4PagePaginationArray;
ImpersonationRegistry.ImpersonationRegistryListResponsesV4PagePaginationArray =
    ImpersonationRegistryListResponsesV4PagePaginationArray;
//# sourceMappingURL=impersonation-registry.js.map