"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrustedDomainListResponsesV4PagePaginationArray = exports.TrustedDomains = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class TrustedDomains extends resource_1.APIResource {
    /**
     * Create a trusted email domain
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email-security/settings/trusted_domains`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists, searches, and sorts an account’s trusted email domains.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/trusted_domains`, TrustedDomainListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a trusted email domain
     */
    delete(trustedDomainId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email-security/settings/trusted_domains/${trustedDomainId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a trusted email domain
     */
    edit(trustedDomainId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/email-security/settings/trusted_domains/${trustedDomainId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a trusted email domain
     */
    get(trustedDomainId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/settings/trusted_domains/${trustedDomainId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.TrustedDomains = TrustedDomains;
class TrustedDomainListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.TrustedDomainListResponsesV4PagePaginationArray = TrustedDomainListResponsesV4PagePaginationArray;
TrustedDomains.TrustedDomainListResponsesV4PagePaginationArray =
    TrustedDomainListResponsesV4PagePaginationArray;
//# sourceMappingURL=trusted-domains.js.map