// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { V4PagePaginationArray } from "../../../pagination.mjs";
export class TrustedDomains extends APIResource {
    /**
     * Create a trusted email domain
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/email-security/settings/trusted_domains`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists, searches, and sorts an account’s trusted email domains.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/email-security/settings/trusted_domains`, TrustedDomainListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete a trusted email domain
     */
    delete(trustedDomainId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/email-security/settings/trusted_domains/${trustedDomainId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a trusted email domain
     */
    edit(trustedDomainId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/email-security/settings/trusted_domains/${trustedDomainId}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a trusted email domain
     */
    get(trustedDomainId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/email-security/settings/trusted_domains/${trustedDomainId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class TrustedDomainListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
TrustedDomains.TrustedDomainListResponsesV4PagePaginationArray =
    TrustedDomainListResponsesV4PagePaginationArray;
//# sourceMappingURL=trusted-domains.mjs.map