"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockdownsV4PagePaginationArray = exports.Lockdowns = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Lockdowns extends resource_1.APIResource {
    /**
     * Creates a new Zone Lockdown rule.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/firewall/lockdowns`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an existing Zone Lockdown rule.
     */
    update(lockDownsId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/firewall/lockdowns/${lockDownsId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches Zone Lockdown rules. You can filter the results using several optional
     * parameters.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/firewall/lockdowns`, LockdownsV4PagePaginationArray, {
            query,
            ...options,
        });
    }
    /**
     * Deletes an existing Zone Lockdown rule.
     */
    delete(lockDownsId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/firewall/lockdowns/${lockDownsId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches the details of a Zone Lockdown rule.
     */
    get(lockDownsId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/firewall/lockdowns/${lockDownsId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Lockdowns = Lockdowns;
class LockdownsV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.LockdownsV4PagePaginationArray = LockdownsV4PagePaginationArray;
Lockdowns.LockdownsV4PagePaginationArray = LockdownsV4PagePaginationArray;
//# sourceMappingURL=lockdowns.js.map