// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Previews extends APIResource {
    /**
     * Create a new preview health check.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/healthchecks/preview`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete a health check.
     */
    delete(healthcheckId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/healthchecks/preview/${healthcheckId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a single configured health check preview.
     */
    get(healthcheckId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/healthchecks/preview/${healthcheckId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=previews.mjs.map