"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TLSGetResponsesSinglePage = exports.TLS = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class TLS extends resource_1.APIResource {
    /**
     * Update the tls setting value for the hostname.
     */
    update(settingId, hostname, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/hostnames/settings/${settingId}/${hostname}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete the tls setting value for the hostname.
     */
    delete(settingId, hostname, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/hostnames/settings/${settingId}/${hostname}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * List the requested TLS setting for the hostnames under this zone.
     */
    get(settingId, params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/hostnames/settings/${settingId}`, TLSGetResponsesSinglePage, options);
    }
}
exports.TLS = TLS;
class TLSGetResponsesSinglePage extends pagination_1.SinglePage {
}
exports.TLSGetResponsesSinglePage = TLSGetResponsesSinglePage;
TLS.TLSGetResponsesSinglePage = TLSGetResponsesSinglePage;
//# sourceMappingURL=tls.js.map