// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class TLS extends APIResource {
    /**
     * Update the tls setting value for the hostname.
     */
    update(settingId, hostname, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/hostnames/settings/${settingId}/${hostname}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete the tls setting value for the hostname.
     */
    delete(settingId, hostname, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/hostnames/settings/${settingId}/${hostname}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * List the requested TLS setting for the hostnames under this zone.
     */
    get(settingId, params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/hostnames/settings/${settingId}`, TLSGetResponsesSinglePage, options);
    }
}
export class TLSGetResponsesSinglePage extends SinglePage {
}
TLS.TLSGetResponsesSinglePage = TLSGetResponsesSinglePage;
//# sourceMappingURL=tls.mjs.map