import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as HyperdriveAPI from "./hyperdrive.js";
import { HyperdrivesSinglePage } from "./hyperdrive.js";
export declare class Configs extends APIResource {
    /**
     * Creates and returns a new Hyperdrive configuration.
     */
    create(params: ConfigCreateParams, options?: Core.RequestOptions): Core.APIPromise<HyperdriveAPI.Hyperdrive>;
    /**
     * Updates and returns the specified Hyperdrive configuration.
     */
    update(hyperdriveId: string, params: ConfigUpdateParams, options?: Core.RequestOptions): Core.APIPromise<HyperdriveAPI.Hyperdrive>;
    /**
     * Returns a list of Hyperdrives
     */
    list(params: ConfigListParams, options?: Core.RequestOptions): Core.PagePromise<HyperdrivesSinglePage, HyperdriveAPI.Hyperdrive>;
    /**
     * Deletes the specified Hyperdrive.
     */
    delete(hyperdriveId: string, params: ConfigDeleteParams, options?: Core.RequestOptions): Core.APIPromise<ConfigDeleteResponse | null>;
    /**
     * Patches and returns the specified Hyperdrive configuration. Custom caching
     * settings are not kept if caching is disabled.
     */
    edit(hyperdriveId: string, params: ConfigEditParams, options?: Core.RequestOptions): Core.APIPromise<HyperdriveAPI.Hyperdrive>;
    /**
     * Returns the specified Hyperdrive configuration.
     */
    get(hyperdriveId: string, params: ConfigGetParams, options?: Core.RequestOptions): Core.APIPromise<HyperdriveAPI.Hyperdrive>;
}
export type ConfigDeleteResponse = unknown;
export interface ConfigCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    name: string;
    /**
     * Body param:
     */
    origin: ConfigCreateParams.PublicDatabase | ConfigCreateParams.AccessProtectedDatabaseBehindCloudflareTunnel;
    /**
     * Body param:
     */
    caching?: ConfigCreateParams.HyperdriveHyperdriveCachingCommon | ConfigCreateParams.HyperdriveHyperdriveCachingEnabled;
}
export declare namespace ConfigCreateParams {
    interface PublicDatabase {
        /**
         * The name of your origin database.
         */
        database: string;
        /**
         * The host (hostname or IP) of your origin database.
         */
        host: string;
        /**
         * The password required to access your origin database. This value is write-only
         * and never returned by the API.
         */
        password: string;
        /**
         * The port (default: 5432 for Postgres) of your origin database.
         */
        port: number;
        /**
         * Specifies the URL scheme used to connect to your origin database.
         */
        scheme: 'postgres' | 'postgresql';
        /**
         * The user of your origin database.
         */
        user: string;
    }
    interface AccessProtectedDatabaseBehindCloudflareTunnel {
        /**
         * The Client ID of the Access token to use when connecting to the origin database.
         */
        access_client_id: string;
        /**
         * The Client Secret of the Access token to use when connecting to the origin
         * database. This value is write-only and never returned by the API.
         */
        access_client_secret: string;
        /**
         * The name of your origin database.
         */
        database: string;
        /**
         * The host (hostname or IP) of your origin database.
         */
        host: string;
        /**
         * The password required to access your origin database. This value is write-only
         * and never returned by the API.
         */
        password: string;
        /**
         * Specifies the URL scheme used to connect to your origin database.
         */
        scheme: 'postgres' | 'postgresql';
        /**
         * The user of your origin database.
         */
        user: string;
    }
    interface HyperdriveHyperdriveCachingCommon {
        /**
         * When set to true, disables the caching of SQL responses. (Default: false)
         */
        disabled?: boolean;
    }
    interface HyperdriveHyperdriveCachingEnabled {
        /**
         * When set to true, disables the caching of SQL responses. (Default: false)
         */
        disabled?: boolean;
        /**
         * When present, specifies max duration for which items should persist in the
         * cache. Not returned if set to default. (Default: 60)
         */
        max_age?: number;
        /**
         * When present, indicates the number of seconds cache may serve the response after
         * it becomes stale. Not returned if set to default. (Default: 15)
         */
        stale_while_revalidate?: number;
    }
}
export interface ConfigUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    name: string;
    /**
     * Body param:
     */
    origin: ConfigUpdateParams.PublicDatabase | ConfigUpdateParams.AccessProtectedDatabaseBehindCloudflareTunnel;
    /**
     * Body param:
     */
    caching?: ConfigUpdateParams.HyperdriveHyperdriveCachingCommon | ConfigUpdateParams.HyperdriveHyperdriveCachingEnabled;
}
export declare namespace ConfigUpdateParams {
    interface PublicDatabase {
        /**
         * The name of your origin database.
         */
        database: string;
        /**
         * The host (hostname or IP) of your origin database.
         */
        host: string;
        /**
         * The password required to access your origin database. This value is write-only
         * and never returned by the API.
         */
        password: string;
        /**
         * The port (default: 5432 for Postgres) of your origin database.
         */
        port: number;
        /**
         * Specifies the URL scheme used to connect to your origin database.
         */
        scheme: 'postgres' | 'postgresql';
        /**
         * The user of your origin database.
         */
        user: string;
    }
    interface AccessProtectedDatabaseBehindCloudflareTunnel {
        /**
         * The Client ID of the Access token to use when connecting to the origin database.
         */
        access_client_id: string;
        /**
         * The Client Secret of the Access token to use when connecting to the origin
         * database. This value is write-only and never returned by the API.
         */
        access_client_secret: string;
        /**
         * The name of your origin database.
         */
        database: string;
        /**
         * The host (hostname or IP) of your origin database.
         */
        host: string;
        /**
         * The password required to access your origin database. This value is write-only
         * and never returned by the API.
         */
        password: string;
        /**
         * Specifies the URL scheme used to connect to your origin database.
         */
        scheme: 'postgres' | 'postgresql';
        /**
         * The user of your origin database.
         */
        user: string;
    }
    interface HyperdriveHyperdriveCachingCommon {
        /**
         * When set to true, disables the caching of SQL responses. (Default: false)
         */
        disabled?: boolean;
    }
    interface HyperdriveHyperdriveCachingEnabled {
        /**
         * When set to true, disables the caching of SQL responses. (Default: false)
         */
        disabled?: boolean;
        /**
         * When present, specifies max duration for which items should persist in the
         * cache. Not returned if set to default. (Default: 60)
         */
        max_age?: number;
        /**
         * When present, indicates the number of seconds cache may serve the response after
         * it becomes stale. Not returned if set to default. (Default: 15)
         */
        stale_while_revalidate?: number;
    }
}
export interface ConfigListParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface ConfigDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface ConfigEditParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    caching?: ConfigEditParams.HyperdriveHyperdriveCachingCommon | ConfigEditParams.HyperdriveHyperdriveCachingEnabled;
    /**
     * Body param:
     */
    name?: string;
    /**
     * Body param:
     */
    origin?: ConfigEditParams.HyperdriveHyperdriveDatabase | ConfigEditParams.HyperdriveInternetOrigin | ConfigEditParams.HyperdriveOverAccessOrigin;
}
export declare namespace ConfigEditParams {
    interface HyperdriveHyperdriveCachingCommon {
        /**
         * When set to true, disables the caching of SQL responses. (Default: false)
         */
        disabled?: boolean;
    }
    interface HyperdriveHyperdriveCachingEnabled {
        /**
         * When set to true, disables the caching of SQL responses. (Default: false)
         */
        disabled?: boolean;
        /**
         * When present, specifies max duration for which items should persist in the
         * cache. Not returned if set to default. (Default: 60)
         */
        max_age?: number;
        /**
         * When present, indicates the number of seconds cache may serve the response after
         * it becomes stale. Not returned if set to default. (Default: 15)
         */
        stale_while_revalidate?: number;
    }
    interface HyperdriveHyperdriveDatabase {
        /**
         * The name of your origin database.
         */
        database?: string;
        /**
         * The password required to access your origin database. This value is write-only
         * and never returned by the API.
         */
        password?: string;
        /**
         * Specifies the URL scheme used to connect to your origin database.
         */
        scheme?: 'postgres' | 'postgresql';
        /**
         * The user of your origin database.
         */
        user?: string;
    }
    interface HyperdriveInternetOrigin {
        /**
         * The host (hostname or IP) of your origin database.
         */
        host: string;
        /**
         * The port (default: 5432 for Postgres) of your origin database.
         */
        port: number;
    }
    interface HyperdriveOverAccessOrigin {
        /**
         * The Client ID of the Access token to use when connecting to the origin database.
         */
        access_client_id: string;
        /**
         * The Client Secret of the Access token to use when connecting to the origin
         * database. This value is write-only and never returned by the API.
         */
        access_client_secret: string;
        /**
         * The host (hostname or IP) of your origin database.
         */
        host: string;
    }
}
export interface ConfigGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Configs {
    export { type ConfigDeleteResponse as ConfigDeleteResponse, type ConfigCreateParams as ConfigCreateParams, type ConfigUpdateParams as ConfigUpdateParams, type ConfigListParams as ConfigListParams, type ConfigDeleteParams as ConfigDeleteParams, type ConfigEditParams as ConfigEditParams, type ConfigGetParams as ConfigGetParams, };
}
export { HyperdrivesSinglePage };
//# sourceMappingURL=configs.d.ts.map