"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.HyperdrivesSinglePage = exports.Configs = void 0;
const resource_1 = require("../../resource.js");
const hyperdrive_1 = require("./hyperdrive.js");
Object.defineProperty(exports, "HyperdrivesSinglePage", { enumerable: true, get: function () { return hyperdrive_1.HyperdrivesSinglePage; } });
class Configs extends resource_1.APIResource {
    /**
     * Creates and returns a new Hyperdrive configuration.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/hyperdrive/configs`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates and returns the specified Hyperdrive configuration.
     */
    update(hyperdriveId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns a list of Hyperdrives
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/hyperdrive/configs`, hyperdrive_1.HyperdrivesSinglePage, options);
    }
    /**
     * Deletes the specified Hyperdrive.
     */
    delete(hyperdriveId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patches and returns the specified Hyperdrive configuration. Custom caching
     * settings are not kept if caching is disabled.
     */
    edit(hyperdriveId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the specified Hyperdrive configuration.
     */
    get(hyperdriveId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Configs = Configs;
//# sourceMappingURL=configs.js.map