// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { HyperdrivesSinglePage } from "./hyperdrive.mjs";
export class Configs extends APIResource {
    /**
     * Creates and returns a new Hyperdrive configuration.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/hyperdrive/configs`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates and returns the specified Hyperdrive configuration.
     */
    update(hyperdriveId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns a list of Hyperdrives
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/hyperdrive/configs`, HyperdrivesSinglePage, options);
    }
    /**
     * Deletes the specified Hyperdrive.
     */
    delete(hyperdriveId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patches and returns the specified Hyperdrive configuration. Custom caching
     * settings are not kept if caching is disabled.
     */
    edit(hyperdriveId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the specified Hyperdrive configuration.
     */
    get(hyperdriveId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/hyperdrive/configs/${hyperdriveId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export { HyperdrivesSinglePage };
//# sourceMappingURL=configs.mjs.map