import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import { V4PagePaginationArray, type V4PagePaginationArrayParams } from "../../pagination.js";
export declare class PermissionGroups extends APIResource {
    /**
     * List all the permissions groups for an account.
     */
    list(params: PermissionGroupListParams, options?: Core.RequestOptions): Core.PagePromise<PermissionGroupListResponsesV4PagePaginationArray, PermissionGroupListResponse>;
    /**
     * Get information about a specific permission group in an account.
     */
    get(permissionGroupId: string, params: PermissionGroupGetParams, options?: Core.RequestOptions): Core.APIPromise<PermissionGroupGetResponse>;
}
export declare class PermissionGroupListResponsesV4PagePaginationArray extends V4PagePaginationArray<PermissionGroupListResponse> {
}
/**
 * A named group of permissions that map to a group of operations against
 * resources.
 */
export interface PermissionGroupListResponse {
    /**
     * Identifier of the group.
     */
    id: string;
    /**
     * Attributes associated to the permission group.
     */
    meta?: PermissionGroupListResponse.Meta;
    /**
     * Name of the group.
     */
    name?: string;
}
export declare namespace PermissionGroupListResponse {
    /**
     * Attributes associated to the permission group.
     */
    interface Meta {
        key?: string;
        value?: string;
    }
}
/**
 * A named group of permissions that map to a group of operations against
 * resources.
 */
export interface PermissionGroupGetResponse {
    /**
     * Identifier of the group.
     */
    id: string;
    /**
     * Attributes associated to the permission group.
     */
    meta?: PermissionGroupGetResponse.Meta;
    /**
     * Name of the group.
     */
    name?: string;
}
export declare namespace PermissionGroupGetResponse {
    /**
     * Attributes associated to the permission group.
     */
    interface Meta {
        key?: string;
        value?: string;
    }
}
export interface PermissionGroupListParams extends V4PagePaginationArrayParams {
    /**
     * Path param: Account identifier tag.
     */
    account_id: string;
    /**
     * Query param: ID of the permission group to be fetched.
     */
    id?: string;
    /**
     * Query param: Label of the permission group to be fetched.
     */
    label?: string;
    /**
     * Query param: Name of the permission group to be fetched.
     */
    name?: string;
}
export interface PermissionGroupGetParams {
    /**
     * Account identifier tag.
     */
    account_id: string;
}
export declare namespace PermissionGroups {
    export { type PermissionGroupListResponse as PermissionGroupListResponse, type PermissionGroupGetResponse as PermissionGroupGetResponse, PermissionGroupListResponsesV4PagePaginationArray as PermissionGroupListResponsesV4PagePaginationArray, type PermissionGroupListParams as PermissionGroupListParams, type PermissionGroupGetParams as PermissionGroupGetParams, };
}
//# sourceMappingURL=permission-groups.d.ts.map