// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { V4PagePaginationArray } from "../../pagination.mjs";
export class ResourceGroups extends APIResource {
    /**
     * Create a new Resource Group under the specified account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/iam/resource_groups`, { body, ...options });
    }
    /**
     * Modify an existing resource group.
     */
    update(resourceGroupId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/iam/resource_groups/${resourceGroupId}`, {
            body,
            ...options,
        });
    }
    /**
     * List all the resource groups for an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/iam/resource_groups`, ResourceGroupListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Remove a resource group from an account.
     */
    delete(resourceGroupId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/iam/resource_groups/${resourceGroupId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get information about a specific resource group in an account.
     */
    get(resourceGroupId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/iam/resource_groups/${resourceGroupId}`, options);
    }
}
export class ResourceGroupListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
ResourceGroups.ResourceGroupListResponsesV4PagePaginationArray =
    ResourceGroupListResponsesV4PagePaginationArray;
//# sourceMappingURL=resource-groups.mjs.map