"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Variants = void 0;
const resource_1 = require("../../../resource.js");
class Variants extends resource_1.APIResource {
    /**
     * Specify variants that allow you to resize images for different use cases.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/images/v1/variants`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists existing variants.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/images/v1/variants`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deleting a variant purges the cache for all images associated with the variant.
     */
    delete(variantId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/images/v1/variants/${variantId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updating a variant purges the cache for all images associated with the variant.
     */
    edit(variantId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/images/v1/variants/${variantId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch details for a single variant.
     */
    get(variantId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/images/v1/variants/${variantId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Variants = Variants;
//# sourceMappingURL=variants.js.map