import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class DomainHistoryResource extends APIResource {
    /**
     * Gets historical security threat and content categories currently and previously
     * assigned to a domain.
     */
    get(params: DomainHistoryGetParams, options?: Core.RequestOptions): Core.APIPromise<DomainHistoryGetResponse | null>;
}
export interface DomainHistory {
    categorizations?: Array<DomainHistory.Categorization>;
    domain?: string;
}
export declare namespace DomainHistory {
    interface Categorization {
        categories?: Array<unknown>;
        end?: string;
        start?: string;
    }
}
export type DomainHistoryGetResponse = Array<DomainHistory>;
export interface DomainHistoryGetParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Query param:
     */
    domain?: string;
}
export declare namespace DomainHistoryResource {
    export { type DomainHistory as DomainHistory, type DomainHistoryGetResponse as DomainHistoryGetResponse, type DomainHistoryGetParams as DomainHistoryGetParams, };
}
//# sourceMappingURL=domain-history.d.ts.map