// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as DownloadsAPI from "./downloads.mjs";
import { Downloads } from "./downloads.mjs";
import * as PermissionsAPI from "./permissions.mjs";
import { Permissions, } from "./permissions.mjs";
import * as SnapshotsAPI from "./snapshots.mjs";
import { Snapshots } from "./snapshots.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class IndicatorFeeds extends APIResource {
    constructor() {
        super(...arguments);
        this.snapshots = new SnapshotsAPI.Snapshots(this._client);
        this.permissions = new PermissionsAPI.Permissions(this._client);
        this.downloads = new DownloadsAPI.Downloads(this._client);
    }
    /**
     * Create new indicator feed
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/intel/indicator-feeds`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update indicator feed metadata
     */
    update(feedId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/intel/indicator-feeds/${feedId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get indicator feeds owned by this account
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/intel/indicator-feeds`, IndicatorFeedListResponsesSinglePage, options);
    }
    /**
     * Get indicator feed data
     */
    data(feedId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/intel/indicator-feeds/${feedId}/data`, {
            ...options,
            headers: { Accept: 'text/csv', ...options?.headers },
        });
    }
    /**
     * Get indicator feed metadata
     */
    get(feedId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/intel/indicator-feeds/${feedId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class IndicatorFeedListResponsesSinglePage extends SinglePage {
}
IndicatorFeeds.IndicatorFeedListResponsesSinglePage = IndicatorFeedListResponsesSinglePage;
IndicatorFeeds.Snapshots = Snapshots;
IndicatorFeeds.Permissions = Permissions;
IndicatorFeeds.Downloads = Downloads;
//# sourceMappingURL=indicator-feeds.mjs.map