"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Permissions = void 0;
const resource_1 = require("../../../resource.js");
class Permissions extends resource_1.APIResource {
    /**
     * Grant permission to indicator feed
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/intel/indicator-feeds/permissions/add`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List indicator feed permissions
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/intel/indicator-feeds/permissions/view`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Revoke permission to indicator feed
     */
    delete(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/intel/indicator-feeds/permissions/remove`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Permissions = Permissions;
//# sourceMappingURL=permissions.js.map