// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Permissions extends APIResource {
    /**
     * Grant permission to indicator feed
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/intel/indicator-feeds/permissions/add`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List indicator feed permissions
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/intel/indicator-feeds/permissions/view`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Revoke permission to indicator feed
     */
    delete(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/intel/indicator-feeds/permissions/remove`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=permissions.mjs.map