import { APIResource } from "../../resource.js";
import * as DNSAPI from "./dns.js";
import { DNS, DNSListParams, DNSV4PagePagination } from "./dns.js";
import * as DomainHistoryAPI from "./domain-history.js";
import { DomainHistory, DomainHistoryGetParams, DomainHistoryGetResponse, DomainHistoryResource } from "./domain-history.js";
import * as IPListsAPI from "./ip-lists.js";
import { IPList, IPListGetParams, IPLists, IPListsSinglePage } from "./ip-lists.js";
import * as IPsAPI from "./ips.js";
import { IP, IPGetParams, IPGetResponse, IPs } from "./ips.js";
import * as MiscategorizationsAPI from "./miscategorizations.js";
import { MiscategorizationCreateParams, MiscategorizationCreateResponse, Miscategorizations } from "./miscategorizations.js";
import * as SinkholesAPI from "./sinkholes.js";
import { Sinkhole, SinkholeListParams, Sinkholes, SinkholesSinglePage } from "./sinkholes.js";
import * as WhoisAPI from "./whois.js";
import { Whois, WhoisGetParams, WhoisGetResponse } from "./whois.js";
import * as ASNAPI from "./asn/asn.js";
import { ASN, ASNGetParams } from "./asn/asn.js";
import * as AttackSurfaceReportAPI from "./attack-surface-report/attack-surface-report.js";
import { AttackSurfaceReport } from "./attack-surface-report/attack-surface-report.js";
import * as DomainsAPI from "./domains/domains.js";
import { Domain, DomainGetParams, Domains } from "./domains/domains.js";
import * as IndicatorFeedsAPI from "./indicator-feeds/indicator-feeds.js";
import { IndicatorFeedCreateParams, IndicatorFeedCreateResponse, IndicatorFeedDataParams, IndicatorFeedDataResponse, IndicatorFeedGetParams, IndicatorFeedGetResponse, IndicatorFeedListParams, IndicatorFeedListResponse, IndicatorFeedListResponsesSinglePage, IndicatorFeedUpdateParams, IndicatorFeedUpdateResponse, IndicatorFeeds } from "./indicator-feeds/indicator-feeds.js";
export declare class Intel extends APIResource {
    asn: ASNAPI.ASN;
    dns: DNSAPI.DNS;
    domains: DomainsAPI.Domains;
    domainHistory: DomainHistoryAPI.DomainHistoryResource;
    ips: IPsAPI.IPs;
    ipLists: IPListsAPI.IPLists;
    miscategorizations: MiscategorizationsAPI.Miscategorizations;
    whois: WhoisAPI.Whois;
    indicatorFeeds: IndicatorFeedsAPI.IndicatorFeeds;
    sinkholes: SinkholesAPI.Sinkholes;
    attackSurfaceReport: AttackSurfaceReportAPI.AttackSurfaceReport;
}
export declare namespace Intel {
    export { ASN as ASN, type ASNGetParams as ASNGetParams };
    export { type DNS as DNS, DNSV4PagePagination as DNSV4PagePagination, type DNSListParams as DNSListParams };
    export { Domains as Domains, type Domain as Domain, type DomainGetParams as DomainGetParams };
    export { DomainHistoryResource as DomainHistoryResource, type DomainHistory as DomainHistory, type DomainHistoryGetResponse as DomainHistoryGetResponse, type DomainHistoryGetParams as DomainHistoryGetParams, };
    export { IPs as IPs, type IP as IP, type IPGetResponse as IPGetResponse, type IPGetParams as IPGetParams };
    export { IPLists as IPLists, type IPList as IPList, IPListsSinglePage as IPListsSinglePage, type IPListGetParams as IPListGetParams, };
    export { Miscategorizations as Miscategorizations, type MiscategorizationCreateResponse as MiscategorizationCreateResponse, type MiscategorizationCreateParams as MiscategorizationCreateParams, };
    export { type Whois as Whois, type WhoisGetResponse as WhoisGetResponse, type WhoisGetParams as WhoisGetParams, };
    export { IndicatorFeeds as IndicatorFeeds, type IndicatorFeedCreateResponse as IndicatorFeedCreateResponse, type IndicatorFeedUpdateResponse as IndicatorFeedUpdateResponse, type IndicatorFeedListResponse as IndicatorFeedListResponse, type IndicatorFeedDataResponse as IndicatorFeedDataResponse, type IndicatorFeedGetResponse as IndicatorFeedGetResponse, IndicatorFeedListResponsesSinglePage as IndicatorFeedListResponsesSinglePage, type IndicatorFeedCreateParams as IndicatorFeedCreateParams, type IndicatorFeedUpdateParams as IndicatorFeedUpdateParams, type IndicatorFeedListParams as IndicatorFeedListParams, type IndicatorFeedDataParams as IndicatorFeedDataParams, type IndicatorFeedGetParams as IndicatorFeedGetParams, };
    export { Sinkholes as Sinkholes, type Sinkhole as Sinkhole, SinkholesSinglePage as SinkholesSinglePage, type SinkholeListParams as SinkholeListParams, };
    export { AttackSurfaceReport as AttackSurfaceReport };
}
//# sourceMappingURL=intel.d.ts.map