import { APIResource } from "../resource.js";
import * as Core from "../core.js";
export declare class IPs extends APIResource {
    /**
     * Get IPs used on the Cloudflare/JD Cloud network, see
     * https://www.cloudflare.com/ips for Cloudflare IPs or
     * https://developers.cloudflare.com/china-network/reference/infrastructure/ for JD
     * Cloud IPs.
     */
    list(query?: IPListParams, options?: Core.RequestOptions): Core.APIPromise<IPListResponse>;
    list(options?: Core.RequestOptions): Core.APIPromise<IPListResponse>;
}
export interface IPs {
    /**
     * A digest of the IP data. Useful for determining if the data has changed.
     */
    etag?: string;
    /**
     * List of Cloudflare IPv4 CIDR addresses.
     */
    ipv4_cidrs?: Array<string>;
    /**
     * List of Cloudflare IPv6 CIDR addresses.
     */
    ipv6_cidrs?: Array<string>;
}
export interface JDCloudIPs {
    /**
     * A digest of the IP data. Useful for determining if the data has changed.
     */
    etag?: string;
    /**
     * List of Cloudflare IPv4 CIDR addresses.
     */
    ipv4_cidrs?: Array<string>;
    /**
     * List of Cloudflare IPv6 CIDR addresses.
     */
    ipv6_cidrs?: Array<string>;
    /**
     * List IPv4 and IPv6 CIDRs, only populated if `?networks=jdcloud` is used.
     */
    jdcloud_cidrs?: Array<string>;
}
export type IPListResponse = IPs | JDCloudIPs;
export interface IPListParams {
    /**
     * Specified as `jdcloud` to list IPs used by JD Cloud data centers.
     */
    networks?: string;
}
//# sourceMappingURL=ips.d.ts.map