"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeylessCertificatesSinglePage = exports.KeylessCertificates = void 0;
const resource_1 = require("../resource.js");
const pagination_1 = require("../pagination.js");
class KeylessCertificates extends resource_1.APIResource {
    /**
     * Create Keyless SSL Configuration
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/keyless_certificates`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all Keyless SSL configurations for a given zone.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/keyless_certificates`, KeylessCertificatesSinglePage, options);
    }
    /**
     * Delete Keyless SSL Configuration
     */
    delete(keylessCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/keyless_certificates/${keylessCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * This will update attributes of a Keyless SSL. Consists of one or more of the
     * following: host,name,port.
     */
    edit(keylessCertificateId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/keyless_certificates/${keylessCertificateId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get details for one Keyless SSL configuration.
     */
    get(keylessCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/keyless_certificates/${keylessCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.KeylessCertificates = KeylessCertificates;
class KeylessCertificatesSinglePage extends pagination_1.SinglePage {
}
exports.KeylessCertificatesSinglePage = KeylessCertificatesSinglePage;
//# sourceMappingURL=keyless-certificates.js.map