// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../resource.mjs";
import { SinglePage } from "../pagination.mjs";
export class KeylessCertificates extends APIResource {
    /**
     * Create Keyless SSL Configuration
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/keyless_certificates`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all Keyless SSL configurations for a given zone.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/keyless_certificates`, KeylessCertificatesSinglePage, options);
    }
    /**
     * Delete Keyless SSL Configuration
     */
    delete(keylessCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/keyless_certificates/${keylessCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * This will update attributes of a Keyless SSL. Consists of one or more of the
     * following: host,name,port.
     */
    edit(keylessCertificateId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/keyless_certificates/${keylessCertificateId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get details for one Keyless SSL configuration.
     */
    get(keylessCertificateId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/keyless_certificates/${keylessCertificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class KeylessCertificatesSinglePage extends SinglePage {
}
//# sourceMappingURL=keyless-certificates.mjs.map