"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Analytics = void 0;
const resource_1 = require("../../../resource.js");
class Analytics extends resource_1.APIResource {
    /**
     * Retrieves Workers KV request metrics for the given account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/storage/analytics`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieves Workers KV stored data metrics for the given account.
     */
    stored(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/storage/analytics/stored`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Analytics = Analytics;
//# sourceMappingURL=analytics.js.map