// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Analytics extends APIResource {
    /**
     * Retrieves Workers KV request metrics for the given account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/storage/analytics`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieves Workers KV stored data metrics for the given account.
     */
    stored(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/storage/analytics/stored`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=analytics.mjs.map