"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeysCursorLimitPagination = exports.Keys = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Keys extends resource_1.APIResource {
    /**
     * Lists a namespace's keys.
     */
    list(namespaceId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/storage/kv/namespaces/${namespaceId}/keys`, KeysCursorLimitPagination, { query, ...options });
    }
}
exports.Keys = Keys;
class KeysCursorLimitPagination extends pagination_1.CursorLimitPagination {
}
exports.KeysCursorLimitPagination = KeysCursorLimitPagination;
Keys.KeysCursorLimitPagination = KeysCursorLimitPagination;
//# sourceMappingURL=keys.js.map