import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Metadata extends APIResource {
    /**
     * Returns the metadata associated with the given key in the given namespace. Use
     * URL-encoding to use special characters (for example, `:`, `!`, `%`) in the key
     * name.
     */
    get(namespaceId: string, keyName: string, params: MetadataGetParams, options?: Core.RequestOptions): Core.APIPromise<MetadataGetResponse>;
}
/**
 * Arbitrary JSON that is associated with a key.
 */
export type MetadataGetResponse = Record<string, unknown>;
export interface MetadataGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Metadata {
    export { type MetadataGetResponse as MetadataGetResponse, type MetadataGetParams as MetadataGetParams };
}
//# sourceMappingURL=metadata.d.ts.map