"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NamespacesV4PagePaginationArray = exports.Namespaces = void 0;
const resource_1 = require("../../../resource.js");
const AnalyticsAPI = __importStar(require("./analytics.js"));
const analytics_1 = require("./analytics.js");
const KeysAPI = __importStar(require("./keys.js"));
const keys_1 = require("./keys.js");
const MetadataAPI = __importStar(require("./metadata.js"));
const metadata_1 = require("./metadata.js");
const ValuesAPI = __importStar(require("./values.js"));
const values_1 = require("./values.js");
const pagination_1 = require("../../../pagination.js");
class Namespaces extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.analytics = new AnalyticsAPI.Analytics(this._client);
        this.keys = new KeysAPI.Keys(this._client);
        this.metadata = new MetadataAPI.Metadata(this._client);
        this.values = new ValuesAPI.Values(this._client);
    }
    /**
     * Creates a namespace under the given title. A `400` is returned if the account
     * already owns a namespace with this title. A namespace must be explicitly deleted
     * to be replaced.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/storage/kv/namespaces`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Modifies a namespace's title.
     */
    update(namespaceId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/storage/kv/namespaces/${namespaceId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns the namespaces owned by an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/storage/kv/namespaces`, NamespacesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletes the namespace corresponding to the given ID.
     */
    delete(namespaceId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/storage/kv/namespaces/${namespaceId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Remove multiple KV pairs from the namespace. Body should be an array of up to
     * 10,000 keys to be removed.
     */
    bulkDelete(namespaceId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/storage/kv/namespaces/${namespaceId}/bulk/delete`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Write multiple keys and values at once. Body should be an array of up to 10,000
     * key-value pairs to be stored, along with optional expiration information.
     * Existing values and expirations will be overwritten. If neither `expiration` nor
     * `expiration_ttl` is specified, the key-value pair will never expire. If both are
     * set, `expiration_ttl` is used and `expiration` is ignored. The entire request
     * size must be 100 megabytes or less.
     */
    bulkUpdate(namespaceId, params, options) {
        const { account_id, body } = params;
        return this._client.put(`/accounts/${account_id}/storage/kv/namespaces/${namespaceId}/bulk`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get the namespace corresponding to the given ID.
     */
    get(namespaceId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/storage/kv/namespaces/${namespaceId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Namespaces = Namespaces;
class NamespacesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.NamespacesV4PagePaginationArray = NamespacesV4PagePaginationArray;
Namespaces.NamespacesV4PagePaginationArray = NamespacesV4PagePaginationArray;
Namespaces.Analytics = analytics_1.Analytics;
Namespaces.Keys = keys_1.Keys;
Namespaces.KeysCursorLimitPagination = keys_1.KeysCursorLimitPagination;
Namespaces.Metadata = metadata_1.Metadata;
Namespaces.Values = values_1.Values;
//# sourceMappingURL=namespaces.js.map