import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { type Response } from "../../../_shims/index.js";
export declare class Values extends APIResource {
    /**
     * Write a value identified by a key. Use URL-encoding to use special characters
     * (for example, `:`, `!`, `%`) in the key name. Body should be the value to be
     * stored. If JSON metadata to be associated with the key/value pair is needed, use
     * `multipart/form-data` content type for your PUT request (see dropdown below in
     * `REQUEST BODY SCHEMA`). Existing values, expirations, and metadata will be
     * overwritten. If neither `expiration` nor `expiration_ttl` is specified, the
     * key-value pair will never expire. If both are set, `expiration_ttl` is used and
     * `expiration` is ignored.
     */
    update(namespaceId: string, keyName: string, params: ValueUpdateParams, options?: Core.RequestOptions): Core.APIPromise<ValueUpdateResponse | null>;
    /**
     * Remove a KV pair from the namespace. Use URL-encoding to use special characters
     * (for example, `:`, `!`, `%`) in the key name.
     */
    delete(namespaceId: string, keyName: string, params: ValueDeleteParams, options?: Core.RequestOptions): Core.APIPromise<ValueDeleteResponse | null>;
    /**
     * Returns the value associated with the given key in the given namespace. Use
     * URL-encoding to use special characters (for example, `:`, `!`, `%`) in the key
     * name. If the KV-pair is set to expire at some point, the expiration time as
     * measured in seconds since the UNIX epoch will be returned in the `expiration`
     * response header.
     */
    get(namespaceId: string, keyName: string, params: ValueGetParams, options?: Core.RequestOptions): Core.APIPromise<Response>;
}
export interface ValueUpdateResponse {
}
export interface ValueDeleteResponse {
}
export interface ValueUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: Arbitrary JSON to be associated with a key/value pair.
     */
    metadata: string;
    /**
     * Body param: A byte sequence to be stored, up to 25 MiB in length.
     */
    value: string;
    /**
     * Query param: The time, measured in number of seconds since the UNIX epoch, at
     * which the key should expire.
     */
    expiration?: number;
    /**
     * Query param: The number of seconds for which the key should be visible before it
     * expires. At least 60.
     */
    expiration_ttl?: number;
}
export interface ValueDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface ValueGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Values {
    export { type ValueUpdateResponse as ValueUpdateResponse, type ValueDeleteResponse as ValueDeleteResponse, type ValueUpdateParams as ValueUpdateParams, type ValueDeleteParams as ValueDeleteParams, type ValueGetParams as ValueGetParams, };
}
//# sourceMappingURL=values.d.ts.map