import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import { SinglePage } from "../../pagination.js";
export declare class Detections extends APIResource {
    /**
     * Create user-defined detection pattern for Leaked Credential Checks
     */
    create(params: DetectionCreateParams, options?: Core.RequestOptions): Core.APIPromise<DetectionCreateResponse>;
    /**
     * Update user-defined detection pattern for Leaked Credential Checks
     */
    update(detectionId: string, params: DetectionUpdateParams, options?: Core.RequestOptions): Core.APIPromise<DetectionUpdateResponse>;
    /**
     * List user-defined detection patterns for Leaked Credential Checks
     */
    list(params: DetectionListParams, options?: Core.RequestOptions): Core.PagePromise<DetectionListResponsesSinglePage, DetectionListResponse>;
    /**
     * Remove user-defined detection pattern for Leaked Credential Checks
     */
    delete(detectionId: string, params: DetectionDeleteParams, options?: Core.RequestOptions): Core.APIPromise<DetectionDeleteResponse>;
}
export declare class DetectionListResponsesSinglePage extends SinglePage<DetectionListResponse> {
}
/**
 * A custom set of username/password expressions to match Leaked Credential Checks
 * on
 */
export interface DetectionCreateResponse {
    /**
     * The unique ID for this custom detection
     */
    id?: string;
    /**
     * The ruleset expression to use in matching the password in a request
     */
    password?: string;
    /**
     * The ruleset expression to use in matching the username in a request
     */
    username?: string;
}
/**
 * A custom set of username/password expressions to match Leaked Credential Checks
 * on
 */
export interface DetectionUpdateResponse {
    /**
     * The unique ID for this custom detection
     */
    id?: string;
    /**
     * The ruleset expression to use in matching the password in a request
     */
    password?: string;
    /**
     * The ruleset expression to use in matching the username in a request
     */
    username?: string;
}
/**
 * A custom set of username/password expressions to match Leaked Credential Checks
 * on
 */
export interface DetectionListResponse {
    /**
     * The unique ID for this custom detection
     */
    id?: string;
    /**
     * The ruleset expression to use in matching the password in a request
     */
    password?: string;
    /**
     * The ruleset expression to use in matching the username in a request
     */
    username?: string;
}
export type DetectionDeleteResponse = unknown;
export interface DetectionCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: The ruleset expression to use in matching the password in a request
     */
    password?: string;
    /**
     * Body param: The ruleset expression to use in matching the username in a request
     */
    username?: string;
}
export interface DetectionUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: The ruleset expression to use in matching the password in a request
     */
    password?: string;
    /**
     * Body param: The ruleset expression to use in matching the username in a request
     */
    username?: string;
}
export interface DetectionListParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface DetectionDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Detections {
    export { type DetectionCreateResponse as DetectionCreateResponse, type DetectionUpdateResponse as DetectionUpdateResponse, type DetectionListResponse as DetectionListResponse, type DetectionDeleteResponse as DetectionDeleteResponse, DetectionListResponsesSinglePage as DetectionListResponsesSinglePage, type DetectionCreateParams as DetectionCreateParams, type DetectionUpdateParams as DetectionUpdateParams, type DetectionListParams as DetectionListParams, type DetectionDeleteParams as DetectionDeleteParams, };
}
//# sourceMappingURL=detections.d.ts.map