"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DetectionListResponsesSinglePage = exports.Detections = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Detections extends resource_1.APIResource {
    /**
     * Create user-defined detection pattern for Leaked Credential Checks
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/leaked-credential-checks/detections`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update user-defined detection pattern for Leaked Credential Checks
     */
    update(detectionId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/leaked-credential-checks/detections/${detectionId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List user-defined detection patterns for Leaked Credential Checks
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/leaked-credential-checks/detections`, DetectionListResponsesSinglePage, options);
    }
    /**
     * Remove user-defined detection pattern for Leaked Credential Checks
     */
    delete(detectionId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/leaked-credential-checks/detections/${detectionId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Detections = Detections;
class DetectionListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.DetectionListResponsesSinglePage = DetectionListResponsesSinglePage;
Detections.DetectionListResponsesSinglePage = DetectionListResponsesSinglePage;
//# sourceMappingURL=detections.js.map