// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Detections extends APIResource {
    /**
     * Create user-defined detection pattern for Leaked Credential Checks
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/leaked-credential-checks/detections`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update user-defined detection pattern for Leaked Credential Checks
     */
    update(detectionId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/leaked-credential-checks/detections/${detectionId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List user-defined detection patterns for Leaked Credential Checks
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/leaked-credential-checks/detections`, DetectionListResponsesSinglePage, options);
    }
    /**
     * Remove user-defined detection pattern for Leaked Credential Checks
     */
    delete(detectionId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/leaked-credential-checks/detections/${detectionId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DetectionListResponsesSinglePage extends SinglePage {
}
Detections.DetectionListResponsesSinglePage = DetectionListResponsesSinglePage;
//# sourceMappingURL=detections.mjs.map