import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as DetectionsAPI from "./detections.js";
import { DetectionCreateParams, DetectionCreateResponse, DetectionDeleteParams, DetectionDeleteResponse, DetectionListParams, DetectionListResponse, DetectionListResponsesSinglePage, DetectionUpdateParams, DetectionUpdateResponse, Detections } from "./detections.js";
export declare class LeakedCredentialChecks extends APIResource {
    detections: DetectionsAPI.Detections;
    /**
     * Updates the current status of Leaked Credential Checks
     */
    create(params: LeakedCredentialCheckCreateParams, options?: Core.RequestOptions): Core.APIPromise<LeakedCredentialCheckCreateResponse>;
    /**
     * Retrieves the current status of Leaked Credential Checks
     */
    get(params: LeakedCredentialCheckGetParams, options?: Core.RequestOptions): Core.APIPromise<LeakedCredentialCheckGetResponse>;
}
/**
 * The overall status for Leaked Credential Checks
 */
export interface LeakedCredentialCheckCreateResponse {
    /**
     * Whether or not Leaked Credential Checks are enabled
     */
    enabled?: boolean;
}
/**
 * The overall status for Leaked Credential Checks
 */
export interface LeakedCredentialCheckGetResponse {
    /**
     * Whether or not Leaked Credential Checks are enabled
     */
    enabled?: boolean;
}
export interface LeakedCredentialCheckCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param: Whether or not Leaked Credential Checks are enabled
     */
    enabled?: boolean;
}
export interface LeakedCredentialCheckGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace LeakedCredentialChecks {
    export { Detections as Detections, type DetectionCreateResponse as DetectionCreateResponse, type DetectionUpdateResponse as DetectionUpdateResponse, type DetectionListResponse as DetectionListResponse, type DetectionDeleteResponse as DetectionDeleteResponse, DetectionListResponsesSinglePage as DetectionListResponsesSinglePage, type DetectionCreateParams as DetectionCreateParams, type DetectionUpdateParams as DetectionUpdateParams, type DetectionListParams as DetectionListParams, type DetectionDeleteParams as DetectionDeleteParams, };
}
//# sourceMappingURL=leaked-credential-checks.d.ts.map