// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as PreviewsAPI from "./previews.mjs";
import { Previews } from "./previews.mjs";
import * as RegionsAPI from "./regions.mjs";
import { Regions } from "./regions.mjs";
import * as SearchesAPI from "./searches.mjs";
import { SearchListResponsesV4PagePagination, Searches, } from "./searches.mjs";
import * as MonitorsAPI from "./monitors/monitors.mjs";
import { Monitors, MonitorsSinglePage, } from "./monitors/monitors.mjs";
import * as PoolsAPI from "./pools/pools.mjs";
import { Pools, PoolsSinglePage, } from "./pools/pools.mjs";
import { SinglePage } from "../../pagination.mjs";
export class LoadBalancers extends APIResource {
    constructor() {
        super(...arguments);
        this.monitors = new MonitorsAPI.Monitors(this._client);
        this.pools = new PoolsAPI.Pools(this._client);
        this.previews = new PreviewsAPI.Previews(this._client);
        this.regions = new RegionsAPI.Regions(this._client);
        this.searches = new SearchesAPI.Searches(this._client);
    }
    /**
     * Create a new load balancer.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/load_balancers`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a configured load balancer.
     */
    update(loadBalancerId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/load_balancers/${loadBalancerId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List configured load balancers.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/load_balancers`, LoadBalancersSinglePage, options);
    }
    /**
     * Delete a configured load balancer.
     */
    delete(loadBalancerId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/load_balancers/${loadBalancerId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Apply changes to an existing load balancer, overwriting the supplied properties.
     */
    edit(loadBalancerId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/load_balancers/${loadBalancerId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a single configured load balancer.
     */
    get(loadBalancerId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/load_balancers/${loadBalancerId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class LoadBalancersSinglePage extends SinglePage {
}
LoadBalancers.Monitors = Monitors;
LoadBalancers.MonitorsSinglePage = MonitorsSinglePage;
LoadBalancers.Pools = Pools;
LoadBalancers.PoolsSinglePage = PoolsSinglePage;
LoadBalancers.Previews = Previews;
LoadBalancers.Regions = Regions;
LoadBalancers.Searches = Searches;
LoadBalancers.SearchListResponsesV4PagePagination = SearchListResponsesV4PagePagination;
//# sourceMappingURL=load-balancers.mjs.map