"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Previews = void 0;
const resource_1 = require("../../../resource.js");
class Previews extends resource_1.APIResource {
    /**
     * Preview pools using the specified monitor with provided monitor details. The
     * returned preview_id can be used in the preview endpoint to retrieve the results.
     */
    create(monitorId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/load_balancers/monitors/${monitorId}/preview`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Previews = Previews;
//# sourceMappingURL=previews.js.map