import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class Previews extends APIResource {
    /**
     * Get the result of a previous preview operation using the provided preview_id.
     */
    get(previewId: string, params: PreviewGetParams, options?: Core.RequestOptions): Core.APIPromise<PreviewGetResponse>;
}
/**
 * Resulting health data from a preview operation.
 */
export type PreviewGetResponse = Record<string, PreviewGetResponse.item>;
export declare namespace PreviewGetResponse {
    interface item {
        healthy?: boolean;
        origins?: Array<Record<string, item.load_balancing_origin_health_data>>;
    }
    namespace item {
        /**
         * The origin ipv4/ipv6 address or domain name mapped to it's health data.
         */
        interface load_balancing_origin_health_data {
            failure_reason?: string;
            healthy?: boolean;
            response_code?: number;
            rtt?: string;
        }
    }
}
export interface PreviewGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Previews {
    export { type PreviewGetResponse as PreviewGetResponse, type PreviewGetParams as PreviewGetParams };
}
//# sourceMappingURL=previews.d.ts.map