import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
export declare class Regions extends APIResource {
    /**
     * List all region mappings.
     */
    list(params: RegionListParams, options?: Core.RequestOptions): Core.APIPromise<RegionListResponse>;
    /**
     * Get a single region mapping.
     */
    get(regionId: 'WNAM' | 'ENAM' | 'WEU' | 'EEU' | 'NSAM' | 'SSAM' | 'OC' | 'ME' | 'NAF' | 'SAF' | 'SAS' | 'SEAS' | 'NEAS', params: RegionGetParams, options?: Core.RequestOptions): Core.APIPromise<RegionGetResponse>;
}
export type RegionListResponse = unknown | string | null;
/**
 * A list of countries and subdivisions mapped to a region.
 */
export type RegionGetResponse = unknown | string | null;
export interface RegionListParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Query param: Two-letter alpha-2 country code followed in ISO 3166-1.
     */
    country_code_a2?: string;
    /**
     * Query param: Two-letter subdivision code followed in ISO 3166-2.
     */
    subdivision_code?: string;
    /**
     * Query param: Two-letter subdivision code followed in ISO 3166-2.
     */
    subdivision_code_a2?: string;
}
export interface RegionGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Regions {
    export { type RegionListResponse as RegionListResponse, type RegionGetResponse as RegionGetResponse, type RegionListParams as RegionListParams, type RegionGetParams as RegionGetParams, };
}
//# sourceMappingURL=regions.d.ts.map