"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Regions = void 0;
const resource_1 = require("../../resource.js");
class Regions extends resource_1.APIResource {
    /**
     * List all region mappings.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/load_balancers/regions`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a single region mapping.
     */
    get(regionId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/load_balancers/regions/${regionId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Regions = Regions;
//# sourceMappingURL=regions.js.map