// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Regions extends APIResource {
    /**
     * List all region mappings.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/load_balancers/regions`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a single region mapping.
     */
    get(regionId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/load_balancers/regions/${regionId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=regions.mjs.map