import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Fields extends APIResource {
    /**
     * Lists all fields available for a dataset. The response result is an object with
     * key-value pairs, where keys are field names, and values are descriptions.
     */
    get(datasetId: string | null, params?: FieldGetParams, options?: Core.RequestOptions): Core.APIPromise<FieldGetResponse>;
    get(datasetId: string | null, options?: Core.RequestOptions): Core.APIPromise<FieldGetResponse>;
}
export type FieldGetResponse = unknown;
export interface FieldGetParams {
    /**
     * The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
     */
    account_id?: string;
    /**
     * The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
     */
    zone_id?: string;
}
export declare namespace Fields {
    export { type FieldGetResponse as FieldGetResponse, type FieldGetParams as FieldGetParams };
}
//# sourceMappingURL=fields.d.ts.map