import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as JobsAPI from "../jobs.js";
import { LogpushJobsSinglePage } from "../jobs.js";
export declare class Jobs extends APIResource {
    /**
     * Lists Logpush jobs for an account or zone for a dataset.
     */
    get(datasetId: string | null, params?: JobGetParams, options?: Core.RequestOptions): Core.PagePromise<LogpushJobsSinglePage, JobsAPI.LogpushJob | null>;
    get(datasetId: string | null, options?: Core.RequestOptions): Core.PagePromise<LogpushJobsSinglePage, JobsAPI.LogpushJob | null>;
}
export interface JobGetParams {
    /**
     * The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
     */
    account_id?: string;
    /**
     * The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
     */
    zone_id?: string;
}
export declare namespace Jobs {
    export { type JobGetParams as JobGetParams };
}
export { LogpushJobsSinglePage };
//# sourceMappingURL=jobs.d.ts.map