import { APIResource } from "../../resource.js";
import * as EdgeAPI from "./edge.js";
import { Edge, EdgeCreateParams, EdgeGetParams, InstantLogpushJob, InstantLogpushJobsSinglePage } from "./edge.js";
import * as JobsAPI from "./jobs.js";
import { JobCreateParams, JobDeleteParams, JobDeleteResponse, JobGetParams, JobListParams, JobUpdateParams, Jobs, LogpushJob, LogpushJobsSinglePage, OutputOptions } from "./jobs.js";
import * as OwnershipAPI from "./ownership.js";
import { Ownership, OwnershipCreateParams, OwnershipCreateResponse, OwnershipValidateParams, OwnershipValidation } from "./ownership.js";
import * as ValidateAPI from "./validate.js";
import { Validate, ValidateDestinationExistsParams, ValidateDestinationExistsResponse, ValidateDestinationParams, ValidateDestinationResponse, ValidateOriginParams, ValidateOriginResponse } from "./validate.js";
import * as DatasetsAPI from "./datasets/datasets.js";
import { Datasets } from "./datasets/datasets.js";
export declare class Logpush extends APIResource {
    datasets: DatasetsAPI.Datasets;
    edge: EdgeAPI.Edge;
    jobs: JobsAPI.Jobs;
    ownership: OwnershipAPI.Ownership;
    validate: ValidateAPI.Validate;
}
export declare namespace Logpush {
    export { Datasets as Datasets };
    export { Edge as Edge, type InstantLogpushJob as InstantLogpushJob, InstantLogpushJobsSinglePage as InstantLogpushJobsSinglePage, type EdgeCreateParams as EdgeCreateParams, type EdgeGetParams as EdgeGetParams, };
    export { Jobs as Jobs, type LogpushJob as LogpushJob, type OutputOptions as OutputOptions, type JobDeleteResponse as JobDeleteResponse, LogpushJobsSinglePage as LogpushJobsSinglePage, type JobCreateParams as JobCreateParams, type JobUpdateParams as JobUpdateParams, type JobListParams as JobListParams, type JobDeleteParams as JobDeleteParams, type JobGetParams as JobGetParams, };
    export { Ownership as Ownership, type OwnershipValidation as OwnershipValidation, type OwnershipCreateResponse as OwnershipCreateResponse, type OwnershipCreateParams as OwnershipCreateParams, type OwnershipValidateParams as OwnershipValidateParams, };
    export { Validate as Validate, type ValidateDestinationResponse as ValidateDestinationResponse, type ValidateDestinationExistsResponse as ValidateDestinationExistsResponse, type ValidateOriginResponse as ValidateOriginResponse, type ValidateDestinationParams as ValidateDestinationParams, type ValidateDestinationExistsParams as ValidateDestinationExistsParams, type ValidateOriginParams as ValidateOriginParams, };
}
//# sourceMappingURL=logpush.d.ts.map