import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
export declare class Config extends APIResource {
    /**
     * Updates CMB config.
     */
    create(params: ConfigCreateParams, options?: Core.RequestOptions): Core.APIPromise<CmbConfig | null>;
    /**
     * Deletes CMB config.
     */
    delete(params: ConfigDeleteParams, options?: Core.RequestOptions): Core.APIPromise<ConfigDeleteResponse | null>;
    /**
     * Gets CMB config.
     */
    get(params: ConfigGetParams, options?: Core.RequestOptions): Core.APIPromise<CmbConfig | null>;
}
export interface CmbConfig {
    /**
     * Comma-separated list of regions.
     */
    regions?: string;
}
export type ConfigDeleteResponse = unknown;
export interface ConfigCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: Comma-separated list of regions.
     */
    regions?: string;
}
export interface ConfigDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface ConfigGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Config {
    export { type CmbConfig as CmbConfig, type ConfigDeleteResponse as ConfigDeleteResponse, type ConfigCreateParams as ConfigCreateParams, type ConfigDeleteParams as ConfigDeleteParams, type ConfigGetParams as ConfigGetParams, };
}
//# sourceMappingURL=config.d.ts.map