// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
export class Config extends APIResource {
    /**
     * Updates CMB config.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/logs/control/cmb/config`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes CMB config.
     */
    delete(params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/logs/control/cmb/config`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets CMB config.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/logs/control/cmb/config`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=config.mjs.map