// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Retention extends APIResource {
    /**
     * Updates log retention flag for Logpull API.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/logs/control/retention/flag`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets log retention flag for Logpull API.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/logs/control/retention/flag`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=retention.mjs.map