// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as FullAPI from "./full.mjs";
import { Full } from "./full.mjs";
export class Configs extends APIResource {
    constructor() {
        super(...arguments);
        this.full = new FullAPI.Full(this._client);
    }
    /**
     * Create a new network monitoring configuration.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/mnm/config`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update an existing network monitoring configuration, requires the entire
     * configuration to be updated at once.
     */
    update(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/mnm/config`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete an existing network monitoring configuration.
     */
    delete(params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/mnm/config`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update fields in an existing network monitoring configuration.
     */
    edit(params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/mnm/config`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists default sampling, router IPs and warp devices for account.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/mnm/config`, options)._thenUnwrap((obj) => obj.result);
    }
}
Configs.Full = Full;
//# sourceMappingURL=configs.mjs.map