import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Advertisements extends APIResource {
    /**
     * Update advertisement for rule.
     */
    edit(ruleId: string, params: AdvertisementEditParams, options?: Core.RequestOptions): Core.APIPromise<Advertisement | null>;
}
export interface Advertisement {
    /**
     * Toggle on if you would like Cloudflare to automatically advertise the IP
     * Prefixes within the rule via Magic Transit when the rule is triggered. Only
     * available for users of Magic Transit.
     */
    automatic_advertisement: boolean | null;
}
export interface AdvertisementEditParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param:
     */
    body: unknown;
}
export declare namespace Advertisements {
    export { type Advertisement as Advertisement, type AdvertisementEditParams as AdvertisementEditParams };
}
//# sourceMappingURL=advertisements.d.ts.map