// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import * as AdvertisementsAPI from "./advertisements.mjs";
import { Advertisements } from "./advertisements.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Rules extends APIResource {
    constructor() {
        super(...arguments);
        this.advertisements = new AdvertisementsAPI.Advertisements(this._client);
    }
    /**
     * Create network monitoring rules for account. Currently only supports creating a
     * single rule per API request.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/mnm/rules`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update network monitoring rules for account.
     */
    update(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/mnm/rules`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists network monitoring rules for account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/mnm/rules`, MagicNetworkMonitoringRulesSinglePage, options);
    }
    /**
     * Delete a network monitoring rule for account.
     */
    delete(ruleId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/mnm/rules/${ruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a network monitoring rule for account.
     */
    edit(ruleId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/mnm/rules/${ruleId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List a single network monitoring rule for account.
     */
    get(ruleId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/mnm/rules/${ruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class MagicNetworkMonitoringRulesSinglePage extends SinglePage {
}
Rules.MagicNetworkMonitoringRulesSinglePage = MagicNetworkMonitoringRulesSinglePage;
Rules.Advertisements = Advertisements;
//# sourceMappingURL=rules.mjs.map