"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppListResponsesSinglePage = exports.Apps = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Apps extends resource_1.APIResource {
    /**
     * Creates a new App for an account
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/magic/apps`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an Account App
     */
    update(accountAppId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/apps/${accountAppId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Apps associated with an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/apps`, AppListResponsesSinglePage, options);
    }
    /**
     * Deletes specific Account App.
     */
    delete(accountAppId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/apps/${accountAppId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Apps = Apps;
class AppListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.AppListResponsesSinglePage = AppListResponsesSinglePage;
Apps.AppListResponsesSinglePage = AppListResponsesSinglePage;
//# sourceMappingURL=apps.js.map