// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Apps extends APIResource {
    /**
     * Creates a new App for an account
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/magic/apps`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an Account App
     */
    update(accountAppId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/magic/apps/${accountAppId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Apps associated with an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/magic/apps`, AppListResponsesSinglePage, options);
    }
    /**
     * Deletes specific Account App.
     */
    delete(accountAppId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/magic/apps/${accountAppId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class AppListResponsesSinglePage extends SinglePage {
}
Apps.AppListResponsesSinglePage = AppListResponsesSinglePage;
//# sourceMappingURL=apps.mjs.map