import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as EventsAPI from "./events.js";
import { EventGetParams, EventGetResponse, EventListParams, EventListResponse, Events } from "./events.js";
import * as SnapshotsAPI from "./snapshots.js";
import { SnapshotGetParams, SnapshotGetResponse, SnapshotListParams, SnapshotListResponse, Snapshots } from "./snapshots.js";
import { SinglePage } from "../../../pagination.js";
export declare class Connectors extends APIResource {
    events: EventsAPI.Events;
    snapshots: SnapshotsAPI.Snapshots;
    /**
     * Replace Connector
     */
    update(connectorId: string, params: ConnectorUpdateParams, options?: Core.RequestOptions): Core.APIPromise<ConnectorUpdateResponse>;
    /**
     * List Connectors
     */
    list(params: ConnectorListParams, options?: Core.RequestOptions): Core.PagePromise<ConnectorListResponsesSinglePage, ConnectorListResponse>;
    /**
     * Update Connector
     */
    edit(connectorId: string, params: ConnectorEditParams, options?: Core.RequestOptions): Core.APIPromise<ConnectorEditResponse>;
    /**
     * Fetch Connector
     */
    get(connectorId: string, params: ConnectorGetParams, options?: Core.RequestOptions): Core.APIPromise<ConnectorGetResponse>;
}
export declare class ConnectorListResponsesSinglePage extends SinglePage<ConnectorListResponse> {
}
export interface ConnectorUpdateResponse {
    id: string;
    activated: boolean;
    interrupt_window_duration_hours: number;
    interrupt_window_hour_of_day: number;
    last_updated: string;
    notes: string;
    timezone: string;
    device?: ConnectorUpdateResponse.Device;
    last_heartbeat?: string;
    last_seen_version?: string;
}
export declare namespace ConnectorUpdateResponse {
    interface Device {
        id: string;
        serial_number?: string;
    }
}
export interface ConnectorListResponse {
    id: string;
    activated: boolean;
    interrupt_window_duration_hours: number;
    interrupt_window_hour_of_day: number;
    last_updated: string;
    notes: string;
    timezone: string;
    device?: ConnectorListResponse.Device;
    last_heartbeat?: string;
    last_seen_version?: string;
}
export declare namespace ConnectorListResponse {
    interface Device {
        id: string;
        serial_number?: string;
    }
}
export interface ConnectorEditResponse {
    id: string;
    activated: boolean;
    interrupt_window_duration_hours: number;
    interrupt_window_hour_of_day: number;
    last_updated: string;
    notes: string;
    timezone: string;
    device?: ConnectorEditResponse.Device;
    last_heartbeat?: string;
    last_seen_version?: string;
}
export declare namespace ConnectorEditResponse {
    interface Device {
        id: string;
        serial_number?: string;
    }
}
export interface ConnectorGetResponse {
    id: string;
    activated: boolean;
    interrupt_window_duration_hours: number;
    interrupt_window_hour_of_day: number;
    last_updated: string;
    notes: string;
    timezone: string;
    device?: ConnectorGetResponse.Device;
    last_heartbeat?: string;
    last_seen_version?: string;
}
export declare namespace ConnectorGetResponse {
    interface Device {
        id: string;
        serial_number?: string;
    }
}
export interface ConnectorUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param:
     */
    activated?: boolean;
    /**
     * Body param:
     */
    interrupt_window_duration_hours?: number;
    /**
     * Body param:
     */
    interrupt_window_hour_of_day?: number;
    /**
     * Body param:
     */
    notes?: string;
    /**
     * Body param:
     */
    timezone?: string;
}
export interface ConnectorListParams {
    account_id: string;
}
export interface ConnectorEditParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param:
     */
    activated?: boolean;
    /**
     * Body param:
     */
    interrupt_window_duration_hours?: number;
    /**
     * Body param:
     */
    interrupt_window_hour_of_day?: number;
    /**
     * Body param:
     */
    notes?: string;
    /**
     * Body param:
     */
    timezone?: string;
}
export interface ConnectorGetParams {
    account_id: string;
}
export declare namespace Connectors {
    export { type ConnectorUpdateResponse as ConnectorUpdateResponse, type ConnectorListResponse as ConnectorListResponse, type ConnectorEditResponse as ConnectorEditResponse, type ConnectorGetResponse as ConnectorGetResponse, ConnectorListResponsesSinglePage as ConnectorListResponsesSinglePage, type ConnectorUpdateParams as ConnectorUpdateParams, type ConnectorListParams as ConnectorListParams, type ConnectorEditParams as ConnectorEditParams, type ConnectorGetParams as ConnectorGetParams, };
    export { Events as Events, type EventListResponse as EventListResponse, type EventGetResponse as EventGetResponse, type EventListParams as EventListParams, type EventGetParams as EventGetParams, };
    export { Snapshots as Snapshots, type SnapshotListResponse as SnapshotListResponse, type SnapshotGetResponse as SnapshotGetResponse, type SnapshotListParams as SnapshotListParams, type SnapshotGetParams as SnapshotGetParams, };
}
//# sourceMappingURL=connectors.d.ts.map